package gov.va.vinci.dart.db;

import gov.va.vinci.dart.biz.Activity;
import gov.va.vinci.dart.biz.ResearchStudy;
import gov.va.vinci.dart.common.SingletonShim;
import gov.va.vinci.dart.common.test.BusinessIntegrationTest;
import gov.va.vinci.dart.service.DartObjectFactory;

import java.util.Date;

import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class TestActivityDAO extends BusinessIntegrationTest {

	@BeforeTest
	public void setup() {
		SingletonShim.getBean(DartObjectFactory.class);
	}

	@Test
	public void testOne() throws Exception {
		Assert.assertNull(DartObjectFactory.getInstance().getResearchStudyDAO().findById(0));
		
		ResearchStudy study = ResearchStudy.create("short name", new Date(), new Date(), "Official Name - this is a test!", "DNS");
		Assert.assertNotNull(study);
		Assert.assertTrue(study.getId() > 0);
		
		int activityId = study.getId();
		
		Activity activity = DartObjectFactory.getInstance().getActivityDAO().findById(activityId);
		Assert.assertNotNull(activity);
		Assert.assertTrue(activity.getId() > 0);
		Assert.assertEquals(activity, study);
	}
	
}
